﻿Imports tessnet2
Public Class Main

    Private m_image As Bitmap
    Private m_words As List(Of tessnet2.Word)

    Private Sub btnSelectImage_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSelectImage.Click
        If openFileDialog1.ShowDialog() = DialogResult.OK Then
            m_image = New Bitmap(openFileDialog1.FileName)
            m_image.SetResolution(96, 96)
            lstResult.Items.Clear()
            m_words = Nothing
            Panel2.AutoScrollMinSize = m_image.Size
            Panel2.Refresh()
        End If
    End Sub

    Private Sub Panel2_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles Panel2.Paint
        If m_image IsNot Nothing Then
            e.Graphics.DrawImage(m_image, Panel2.AutoScrollPosition.X, Panel2.AutoScrollPosition.Y)
        End If
        If m_words IsNot Nothing Then
            For Each word As tessnet2.Word In m_words
                Dim pen As Pen = Nothing
                If word.ToString = lstResult.SelectedItem Then
                    pen = New Pen(Color.FromArgb(word.Confidence, 0, 0))
                Else
                    pen = New Pen(Color.FromArgb(255, 128, word.Confidence))
                End If
                e.Graphics.DrawRectangle(pen, word.Left + Panel2.AutoScrollPosition.X, word.Top + Panel2.AutoScrollPosition.Y, word.Rigth - word.Left, word.Bottom - word.Top)
            Next
        End If
    End Sub

    Private Sub btnDoOCR_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDoOCR.Click
        If m_image IsNot Nothing AndAlso cboLang.SelectedItem IsNot Nothing Then
            progressBar1.Value = 0
            lstResult.Items.Clear()
            Dim ocr As New tessnet2.Tesseract()
            ocr.Init(cboLang.SelectedItem.ToString(), False)
            AddHandler ocr.ProgressEvent, AddressOf ocr_ProgressEvent
            ocr.OcrDone = New tessnet2.Tesseract.OcrDoneHandler(AddressOf Done)
            ocr.doOCR(m_image, Rectangle.Empty)
        End If
    End Sub
    Private Sub Done(ByVal words As List(Of tessnet2.Word))
        m_words = words
        Me.Invoke(New FillResult(AddressOf FillResultMethod))
    End Sub

    Private Delegate Sub SetPercent(ByVal percent As Integer)
    Private Sub ocr_ProgressEvent(ByVal percent As Integer)
        progressBar1.Invoke(New SetPercent(AddressOf SetPercentMethod), New Object() {percent})
    End Sub

    Private Sub SetPercentMethod(ByVal percent As Integer)
        progressBar1.Value = percent
    End Sub

    Private Delegate Sub FillResult()
    Private Sub FillResultMethod()
        Dim i As Integer
        progressBar1.Value = 0
        'lstResult.Items.AddRange(m_words.ToArray())
        For i = 0 To m_words.Count - 1
            lstResult.Items.Add(m_words(i).Text)
        Next
        Panel2.Refresh()
    End Sub


    Private Sub lstResult_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstResult.SelectedIndexChanged
        Panel2.Refresh()
    End Sub
End Class